/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.a.ChooseHumanMerfolkOrGoblinEffect;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class AKillerAmongUsCost
extends CostImpl {
    AKillerAmongUsCost() {
        this.text = "Reveal the creature type you chose";
    }

    private AKillerAmongUsCost(AKillerAmongUsCost cost) {
        super((CostImpl)cost);
    }

    public AKillerAmongUsCost copy() {
        return new AKillerAmongUsCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return controllerId != null && controllerId.equals(ChooseHumanMerfolkOrGoblinEffect.getSecretOwner(source, game)) && ChooseHumanMerfolkOrGoblinEffect.getSecretCreatureType(source, game) != null;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (controllerId == null || !controllerId.equals(ChooseHumanMerfolkOrGoblinEffect.getSecretOwner(source, game))) {
            return false;
        }
        SubType creatureType = ChooseHumanMerfolkOrGoblinEffect.getSecretCreatureType(source, game);
        if (creatureType == null) {
            return this.paid;
        }
        Player controller = game.getPlayer(controllerId);
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " reveals the secretly chosen creature type " + creatureType);
        }
        this.paid = true;
        return this.paid;
    }
}

