/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

class AbandonedSarcophagusWatcher
extends Watcher {
    private final Map<UUID, Cards> cycledCardsThisTurn = new HashMap<UUID, Cards>();

    AbandonedSarcophagusWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.CYCLE_CARD) {
            return;
        }
        Card card = game.getCard(event.getSourceId());
        if (card == null) {
            return;
        }
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller == null) {
            return;
        }
        if (!card.isOwnedBy(controller.getId())) {
            return;
        }
        Cards c = this.getCardsCycledThisTurn(event.getPlayerId());
        c.add(card);
        this.cycledCardsThisTurn.put(event.getPlayerId(), c);
    }

    public Cards getCardsCycledThisTurn(UUID playerId) {
        return this.cycledCardsThisTurn.getOrDefault(playerId, (Cards)new CardsImpl());
    }

    public void reset() {
        super.reset();
        this.cycledCardsThisTurn.clear();
    }
}

