/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SoldierToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class AbdelAdrianGorionsWardEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("other nonland permanents you control");

    AbdelAdrianGorionsWardEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of other nonland permanents you control until {this} leaves the battlefield. Create a 1/1 white Soldier creature token for each permanent exiled this way";
    }

    private AbdelAdrianGorionsWardEffect(AbdelAdrianGorionsWardEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbdelAdrianGorionsWardEffect copy() {
        return new AbdelAdrianGorionsWardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.retainZone(Zone.EXILED, game);
        int count = cards.size();
        if (count > 0) {
            new SoldierToken().putOntoBattlefield(count, game, source);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

