/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAttachedControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AbilityActivatedTriggeredAbility
extends TriggeredAbilityImpl {
    AbilityActivatedTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageAttachedControllerEffect(2));
    }

    private AbilityActivatedTriggeredAbility(AbilityActivatedTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AbilityActivatedTriggeredAbility copy() {
        return new AbilityActivatedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.TAPPED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent aura;
        UUID tappedPermanent = null;
        if (event.getType() == GameEvent.EventType.ACTIVATE_ABILITY) {
            tappedPermanent = event.getSourceId();
        }
        if (event.getType() == GameEvent.EventType.TAPPED) {
            tappedPermanent = event.getTargetId();
        }
        return (aura = game.getPermanent(this.getSourceId())) != null && aura.isAttachedTo(tappedPermanent);
    }

    public String getRule() {
        return "Whenever enchanted artifact becomes tapped or a player activates an ability of enchanted artifact without {T} in its activation cost, {this} deals 2 damage to that artifact's controller.";
    }
}

