/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AbundanceReplacementEffect
extends ReplacementEffectImpl {
    AbundanceReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card, you may instead choose land or nonland and reveal cards from the top of your library until you reveal a card of the chosen kind. Put that card into your hand and put all other cards revealed this way on the bottom of your library in any order";
    }

    private AbundanceReplacementEffect(AbundanceReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AbundanceReplacementEffect copy() {
        return new AbundanceReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(event.getPlayerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            FilterCard filter = new FilterCard();
            if (controller.chooseUse(Outcome.Detriment, "Choose card type:", source.getSourceObject(game).getLogName(), "land", "nonland", source, game)) {
                game.informPlayers(controller.getLogName() + "chooses land.");
                filter.add((Predicate)CardType.LAND.getPredicate());
            } else {
                game.informPlayers(controller.getLogName() + "chooses nonland.");
                filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
            }
            CardsImpl toReveal = new CardsImpl();
            Card selectedCard = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (!filter.match(card, source.getControllerId(), source, game)) continue;
                selectedCard = card;
                break;
            }
            controller.moveCards(selectedCard, Zone.HAND, source, game);
            controller.revealCards(sourceObject.getIdName(), (Cards)toReveal, game);
            toReveal.remove(selectedCard);
            controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, true);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player;
        if (event.getPlayerId().equals(source.getControllerId()) && (player = game.getPlayer(source.getControllerId())) != null) {
            return player.chooseUse(Outcome.Detriment, "Choose:", source.getSourceObject(game).getLogName(), "land or nonland and reveal cards from the top", "normal card draw", source, game);
        }
        return false;
    }
}

