/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AbyssalHarvesterEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent();

    AbyssalHarvesterEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature card from a graveyard that was put there this turn. Create a token that's a copy of it, except it's a Nightmare in addition to its other types. Then exile all other Nightmare tokens you control";
    }

    private AbyssalHarvesterEffect(AbyssalHarvesterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbyssalHarvesterEffect copy() {
        return new AbyssalHarvesterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        game.processAction();
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, false, false, null);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        effect.withAdditionalSubType(SubType.NIGHTMARE);
        effect.apply(game, source);
        game.processAction();
        List addedTokens = effect.getAddedPermanents();
        CardsImpl cards = new CardsImpl();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
            if (addedTokens.contains(permanent)) continue;
            cards.add((Object)permanent.getId());
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((Predicate)SubType.NIGHTMARE.getPredicate());
    }
}

