/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AchHansRunEffect
extends OneShotEffect {
    AchHansRunEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may say \"Ach! Hans, run! It's the \u2026\" and the name of a creature card. If you do, search your library for a card with that name, put it onto the battlefield, then shuffle. That creature gains haste. Exile it at the beginning of the next end step";
    }

    private AchHansRunEffect(AchHansRunEffect effect) {
        super((OneShotEffect)effect);
    }

    public AchHansRunEffect copy() {
        return new AchHansRunEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.CREATURE_NAME.getChoice(controller, game, source, false);
        game.informPlayers(controller.getLogName() + ": \"Ach! Hans, run! It's the " + cardName + "!\"");
        FilterCard nameFilter = new FilterCard();
        nameFilter.add((Predicate)new NamePredicate(cardName));
        TargetCardInLibrary target = new TargetCardInLibrary(1, 1, nameFilter);
        if (!controller.searchLibrary(target, source, game)) {
            return false;
        }
        Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
        if (card == null || !controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            return false;
        }
        Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (creature == null) {
            return false;
        }
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        game.addEffect((ContinuousEffect)effect, source);
        ExileTargetEffect exileEffect = new ExileTargetEffect(null, null, Zone.BATTLEFIELD);
        exileEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

