/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AdNauseamEffect
extends OneShotEffect {
    AdNauseamEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top card of your library and put that card into your hand. You lose life equal to its mana value. You may repeat this process any number of times";
    }

    private AdNauseamEffect(AdNauseamEffect effect) {
        super((OneShotEffect)effect);
    }

    public AdNauseamEffect copy() {
        return new AdNauseamEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        String message = "Reveal the top card of your library and put that card into your hand? You lose life equal to its mana value.";
        Card sourceCard = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceCard == null) {
            return false;
        }
        while (controller.chooseUse(this.outcome, message, source, game) && controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
            int cmc = card.getManaValue();
            if (cmc > 0) {
                controller.loseLife(cmc, game, source, false);
            }
            controller.revealCards(sourceCard.getIdName() + " put into hand", (Cards)new CardsImpl(card), game);
            if (!controller.isComputer()) continue;
            break;
        }
        return true;
    }
}

