/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class AdrestiaWatcher
extends Watcher {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent(SubType.ASSASSIN, "an Assassin");
    private final Map<MageObjectReference, Boolean> crewMap = new HashMap<MageObjectReference, Boolean>();

    public AdrestiaWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.CREWED_VEHICLE) {
            MageObjectReference vehicle = new MageObjectReference(event.getSourceId(), game);
            Permanent crewer = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (crewer != null) {
                if (!this.crewMap.containsKey(vehicle)) {
                    this.crewMap.put(vehicle, filter.match((Object)crewer, game));
                } else {
                    this.crewMap.put(vehicle, this.crewMap.get(vehicle) != false || filter.match((Object)crewer, game));
                }
            }
        }
    }

    public void reset() {
        super.reset();
        this.crewMap.clear();
    }

    public static boolean checkIfAssassinCrewed(Permanent vehicle, Game game) {
        return ((AdrestiaWatcher)game.getState().getWatcher(AdrestiaWatcher.class)).crewMap.getOrDefault(new MageObjectReference((MageObject)vehicle, game), Boolean.FALSE);
    }
}

