/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.a.AegarTheFreezingFlameWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AegarTheFreezingFlameTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    AegarTheFreezingFlameTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addWatcher(new AegarTheFreezingFlameWatcher());
    }

    private AegarTheFreezingFlameTriggeredAbility(AegarTheFreezingFlameTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !game.getOpponents(this.getControllerId()).contains(permanent.getControllerId())) {
            return false;
        }
        if (this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePermanentEvent)event), game).stream().mapToInt(DamagedEvent::getExcess).sum() < 1) {
            return false;
        }
        AegarTheFreezingFlameWatcher watcher = (AegarTheFreezingFlameWatcher)game.getState().getWatcher(AegarTheFreezingFlameWatcher.class);
        return watcher != null && watcher.checkDamage(this.getControllerId(), event.getTargetId(), game);
    }

    public AegarTheFreezingFlameTriggeredAbility copy() {
        return new AegarTheFreezingFlameTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature or planeswalker an opponent controls is dealt excess damage, if a Giant, Wizard, or spell you controlled dealt damage to it this turn, draw a card.";
    }
}

