/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.TargetPlayer;

class AegisOfHonorEffect
extends RedirectionEffect {
    private static final FilterInstantOrSorceryCard instantOrSorceryfilter = new FilterInstantOrSorceryCard();

    public AegisOfHonorEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "The next time an instant or sorcery spell would deal damage to you this turn, that spell deals that damage to its controller instead";
    }

    private AegisOfHonorEffect(AegisOfHonorEffect card) {
        super((RedirectionEffect)card);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getControllerId())) {
            Spell spell = null;
            StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
            if (stackObject == null) {
                stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
            }
            if (stackObject instanceof Spell) {
                spell = (Spell)stackObject;
            }
            if (spell != null && instantOrSorceryfilter.match(spell.getCard(), game)) {
                TargetPlayer target = new TargetPlayer();
                target.add(spell.getControllerId(), game);
                this.redirectTarget = target;
                return true;
            }
        }
        return false;
    }

    public AegisOfHonorEffect copy() {
        return new AegisOfHonorEffect(this);
    }
}

