/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.a.AetherChargeEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AetherChargeTriggeredAbility
extends TriggeredAbilityImpl {
    public AetherChargeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AetherChargeEffect(), true);
    }

    private AetherChargeTriggeredAbility(AetherChargeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && permanent.hasSubtype(SubType.BEAST, game) && permanent.isControlledBy(this.controllerId)) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setValue("damageSource", (Object)event.getTargetId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a Beast you control enters, you may have it deal 4 damage to target opponent or planeswalker.";
    }

    public AetherChargeTriggeredAbility copy() {
        return new AetherChargeTriggeredAbility(this);
    }
}

