/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoUnlessAnyPlayerPaysEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AetherRiftEffect
extends OneShotEffect {
    AetherRiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard a card at random. If you discard a creature card this way, return it from your graveyard to the battlefield unless any player pays 5 life";
    }

    private AetherRiftEffect(AetherRiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherRiftEffect copy() {
        return new AetherRiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.discardOne(true, false, source, game);
            if (card != null && card.isCreature(game)) {
                ReturnFromGraveyardToBattlefieldTargetEffect returnEffect = new ReturnFromGraveyardToBattlefieldTargetEffect();
                DoUnlessAnyPlayerPaysEffect doEffect = new DoUnlessAnyPlayerPaysEffect((Effect)returnEffect, (Cost)new PayLifeCost(5), "Pay 5 life to prevent " + card.getLogName() + " to return from graveyard to battlefield?");
                doEffect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                return doEffect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

