/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class AetherVialEffect
extends OneShotEffect {
    AetherVialEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "You may put a creature card with mana value equal to the number of charge counters on {this} from your hand onto the battlefield";
    }

    private AetherVialEffect(AetherVialEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherVialEffect copy() {
        return new AetherVialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && (permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD)) == null) {
            return false;
        }
        int count = permanent.getCounters(game).getCount(CounterType.CHARGE);
        FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value equal to " + count);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, count));
        String choiceText = "Put a " + filter.getMessage() + " from your hand onto the battlefield?";
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.getHand().count((FilterCard)filter, game) == 0 || !controller.chooseUse(this.outcome, choiceText, source, game)) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (controller.choose(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return false;
    }
}

