/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class AethericAmplifierDoubleControllerEffect
extends OneShotEffect {
    AethericAmplifierDoubleControllerEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter you have";
    }

    private AethericAmplifierDoubleControllerEffect(OneShotEffect effect) {
        super(effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set<Counter> counters = controller.getCountersAsCopy().values().stream().map(counter -> CounterType.findByName((String)counter.getName()).createInstance(counter.getCount())).collect(Collectors.toSet());
        if (counters.isEmpty()) {
            return false;
        }
        counters.forEach(counter -> controller.addCounters(counter, source.getControllerId(), source, game));
        return true;
    }

    public AethericAmplifierDoubleControllerEffect copy() {
        return new AethericAmplifierDoubleControllerEffect(this);
    }
}

