/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.TargetCard;

class AetherspoutsEffect
extends OneShotEffect {
    AetherspoutsEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each attacking creature, its owner puts it on the top or bottom of their library";
    }

    private AetherspoutsEffect(AetherspoutsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherspoutsEffect copy() {
        return new AetherspoutsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        game.getPlayerList();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        PlayerList playerList = game.getState().getPlayersInRange(controller.getId(), game);
        playerList.setCurrent((Object)game.getActivePlayerId());
        Player activePlayer = player = game.getPlayer(game.getActivePlayerId());
        do {
            Permanent permanent4;
            Object card;
            ArrayList<Permanent> permanentsToTop = new ArrayList<Permanent>();
            ArrayList<Permanent> permanentsToBottom = new ArrayList<Permanent>();
            for (Permanent permanent2 : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterAttackingCreature(), player.getId(), source, game)) {
                if (!permanent2.isOwnedBy(player.getId())) continue;
                if (player.chooseUse(this.outcome, "Put " + permanent2.getLogName() + " to the top? (else it goes to bottom)", source, game)) {
                    permanentsToTop.add(permanent2);
                    game.informPlayers(permanent2.getLogName() + " goes to the top of " + player.getLogName() + "'s library");
                    continue;
                }
                permanentsToBottom.add(permanent2);
                game.informPlayers(permanent2.getLogName() + " goes to the bottom of " + player.getLogName() + "'s library");
            }
            CardsImpl cards = new CardsImpl();
            ArrayList<Permanent> toLibrary = new ArrayList<Permanent>();
            for (Permanent permanent3 : permanentsToTop) {
                if (permanent3 instanceof PermanentToken) {
                    toLibrary.add(permanent3);
                    continue;
                }
                Card card2 = game.getCard(permanent3.getId());
                if (card2 == null) continue;
                cards.add(card2);
            }
            TargetCard target = new TargetCard(Zone.BATTLEFIELD, new FilterCard("order to put on the top of library (last chosen will be the top most)"));
            while (cards.size() > 1) {
                if (!player.canRespond()) {
                    return false;
                }
                player.choose(Outcome.Neutral, (Cards)cards, target, source, game);
                card = cards.get(target.getFirstTarget(), game);
                if (card != null) {
                    cards.remove((Card)card);
                    permanent4 = game.getPermanent(card.getId());
                    if (permanent4 != null) {
                        toLibrary.add(permanent4);
                    }
                }
                target.clearChosen();
            }
            if (cards.size() == 1 && (permanent4 = game.getPermanent((card = cards.get((UUID)cards.iterator().next(), game)).getId())) != null) {
                toLibrary.add(permanent4);
            }
            for (Permanent permanent4 : toLibrary) {
                player.moveCardToLibraryWithInfo((Card)permanent4, source, game, Zone.BATTLEFIELD, true, false);
            }
            cards.clear();
            toLibrary.clear();
            card = permanentsToBottom.iterator();
            while (card.hasNext()) {
                permanent4 = (Permanent)card.next();
                if (permanent4 instanceof PermanentToken) {
                    toLibrary.add(permanent4);
                    continue;
                }
                Card card3 = game.getCard(permanent4.getId());
                if (card3 == null) continue;
                cards.add(card3);
            }
            target = new TargetCard(Zone.BATTLEFIELD, new FilterCard("order to put on bottom of library (last chosen will be bottommost card)"));
            while (player.canRespond() && cards.size() > 1) {
                player.choose(Outcome.Neutral, (Cards)cards, target, source, game);
                card = cards.get(target.getFirstTarget(), game);
                if (card == null) break;
                cards.remove((Card)card);
                permanent4 = game.getPermanent(card.getId());
                if (permanent4 != null) {
                    toLibrary.add(permanent4);
                }
                target.clearChosen();
            }
            if (cards.size() == 1 && (permanent4 = game.getPermanent((card = cards.get((UUID)cards.iterator().next(), game)).getId())) != null) {
                toLibrary.add(permanent4);
            }
            for (Permanent permanent4 : toLibrary) {
                player.moveCardToLibraryWithInfo((Card)permanent4, source, game, Zone.BATTLEFIELD, false, false);
            }
        } while ((player = playerList.getNext(game, false)) != null && !player.getId().equals(game.getActivePlayerId()) && activePlayer.canRespond());
        return true;
    }
}

