/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AethertowEffect
extends OneShotEffect {
    AethertowEffect() {
        super(Outcome.Removal);
        this.staticText = "Put target attacking or blocking creature on top of its owner's library";
    }

    private AethertowEffect(AethertowEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (targetCreature != null) {
            return controller.putCardsOnTopOfLibrary((Card)targetCreature, game, source, true);
        }
        return false;
    }

    public AethertowEffect copy() {
        return new AethertowEffect(this);
    }
}

