/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AettirAndPriwenEffect
extends ContinuousEffectImpl {
    AettirAndPriwenEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.Benefit);
        this.staticText = "equipped creature has base power and toughness X/X, where X is your life total";
    }

    private AettirAndPriwenEffect(AettirAndPriwenEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AettirAndPriwenEffect copy() {
        return new AettirAndPriwenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getLife).ifPresent(life -> {
            permanent.getPower().setModifiedBaseValue(life.intValue());
            permanent.getToughness().setModifiedBaseValue(life.intValue());
        });
        return true;
    }
}

