/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AfiyaGroveNoCountersAbility
extends StateTriggeredAbility {
    public AfiyaGroveNoCountersAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
    }

    private AfiyaGroveNoCountersAbility(AfiyaGroveNoCountersAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public AfiyaGroveNoCountersAbility copy() {
        return new AfiyaGroveNoCountersAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.getCounters(game).getCount(CounterType.P1P1) == 0;
    }

    public String getRule() {
        return "When {this} has no +1/+1 counters on it, sacrifice it.";
    }
}

