/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class AgathasSoulCauldronExileEffect
extends OneShotEffect {
    AgathasSoulCauldronExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. When a creature card is exiled this way, put a +1/+1 counter on target creature you control";
    }

    private AgathasSoulCauldronExileEffect(AgathasSoulCauldronExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgathasSoulCauldronExileEffect copy() {
        return new AgathasSoulCauldronExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        if (!card.isCreature(game)) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

