/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.DamagedByWatcher;

class AggravateRequirementEffect
extends RequirementEffect {
    AggravateRequirementEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "Each creature dealt damage this way attacks this turn if able";
    }

    private AggravateRequirementEffect(AggravateRequirementEffect effect) {
        super((RequirementEffect)effect);
    }

    public AggravateRequirementEffect copy() {
        return new AggravateRequirementEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        DamagedByWatcher watcher = (DamagedByWatcher)game.getState().getWatcher(DamagedByWatcher.class, source.getSourceId());
        if (watcher != null) {
            return watcher.wasDamaged(permanent, game);
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

