/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class AggressiveBiomancyEffect
extends OneShotEffect {
    AggressiveBiomancyEffect() {
        super(Outcome.Copy);
        this.staticText = "Create X tokens that are copies of target creature you control, except they have \"When this creature enters, it fights up to one target creature you don't control.\"";
    }

    private AggressiveBiomancyEffect(AggressiveBiomancyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creatureToCopy = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || creatureToCopy == null) {
            return false;
        }
        EntersBattlefieldTriggeredAbility fightAbility = new EntersBattlefieldTriggeredAbility((Effect)new FightTargetSourceEffect().setText("it fights up to one target creature you don't control"));
        fightAbility.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue());
        effect.addAdditionalAbilities(new Ability[]{fightAbility});
        effect.setTargetPointer((TargetPointer)new FixedTarget(creatureToCopy, game));
        return effect.apply(game, source);
    }

    public AggressiveBiomancyEffect copy() {
        return new AggressiveBiomancyEffect(this);
    }
}

