/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AgonizingMemoriesEffect
extends OneShotEffect {
    AgonizingMemoriesEffect() {
        super(Outcome.Discard);
        this.staticText = "Look at target player's hand and choose two cards from it. Put them on top of that player's library in any order.";
    }

    private AgonizingMemoriesEffect(AgonizingMemoriesEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgonizingMemoriesEffect copy() {
        return new AgonizingMemoriesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && you != null) {
            this.chooseCardInHandAndPutOnTopOfLibrary(game, source, you, targetPlayer);
            this.chooseCardInHandAndPutOnTopOfLibrary(game, source, you, targetPlayer);
            return true;
        }
        return false;
    }

    private void chooseCardInHandAndPutOnTopOfLibrary(Game game, Ability source, Player you, Player targetPlayer) {
        if (!targetPlayer.getHand().isEmpty()) {
            Card card;
            TargetCard target = new TargetCard(Zone.HAND, new FilterCard("card to put on the top of library (last chosen will be on top)"));
            if (you.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game) && (card = targetPlayer.getHand().get(target.getFirstTarget(), game)) != null) {
                targetPlayer.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
            }
        }
    }
}

