/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.CatToken;
import mage.players.Player;
import mage.target.Target;

class AjanisChosenEffect
extends OneShotEffect {
    AjanisChosenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 2/2 white Cat creature token. If that enchantment is an Aura, you may attach it to the token";
    }

    private AjanisChosenEffect(AjanisChosenEffect effect) {
        super((OneShotEffect)effect);
    }

    public AjanisChosenEffect copy() {
        return new AjanisChosenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CatToken token;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (token = new CatToken()).putOntoBattlefield(1, game, source, source.getControllerId())) {
            Permanent enchantment = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (enchantment != null && enchantment.hasSubtype(SubType.AURA, game)) {
                for (UUID tokenId : token.getLastAddedTokenIds()) {
                    boolean canAttach;
                    Permanent oldCreature;
                    Permanent tokenPermanent = game.getPermanent(tokenId);
                    if (tokenPermanent == null || (oldCreature = game.getPermanent(enchantment.getAttachedTo())) == null || !(canAttach = enchantment.getSpellAbility() == null || !enchantment.getSpellAbility().getTargets().isEmpty() && ((Target)enchantment.getSpellAbility().getTargets().get(0)).canTarget(tokenPermanent.getId(), source, game)) || !controller.chooseUse(Outcome.Neutral, "Attach " + enchantment.getName() + " to the token ?", source, game) || !oldCreature.removeAttachment(enchantment.getId(), source, game)) continue;
                    tokenPermanent.addAttachment(enchantment.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

