/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DefenderAttackedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AkiriFearlessVoyagerTriggeredAbility
extends TriggeredAbilityImpl {
    AkiriFearlessVoyagerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
    }

    private AkiriFearlessVoyagerTriggeredAbility(AkiriFearlessVoyagerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AkiriFearlessVoyagerTriggeredAbility copy() {
        return new AkiriFearlessVoyagerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) return false;
        if (game.getPlayer(event.getTargetId()) == null) return false;
        if (!((DefenderAttackedEvent)event).getAttackers(game).stream().map(Permanent::getAttachments).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.EQUIPMENT, game))) return false;
        return true;
    }

    public String getRule() {
        return "Whenever you attack a player with one or more equipped creatures, draw a card.";
    }
}

