/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AkroanHorseGainControlEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AkroanHorseChangeControlEffect
extends OneShotEffect {
    AkroanHorseChangeControlEffect() {
        super(Outcome.Benefit);
        this.staticText = "an opponent gains control of it";
    }

    private AkroanHorseChangeControlEffect(AkroanHorseChangeControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public AkroanHorseChangeControlEffect copy() {
        return new AkroanHorseChangeControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        AkroanHorseGainControlEffect effect = new AkroanHorseGainControlEffect(Duration.Custom, target.getFirstTarget());
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

