/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AlAbarasCarpetEffect
extends PreventionEffectImpl {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature();

    AlAbarasCarpetEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by attacking creatures without flying";
    }

    private AlAbarasCarpetEffect(AlAbarasCarpetEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public AlAbarasCarpetEffect copy() {
        return new AlAbarasCarpetEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamagePlayerEvent && event.getAmount() > 0) {
            Permanent permanent;
            DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
            if (event.getTargetId().equals(source.getControllerId()) && filter.match((Object)(permanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId())), game)) {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

