/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksEachCombatStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.common.TargetPlayerGainControlSourceEffect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.abilities.effects.common.continuous.CantBeSacrificedSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AlexiosDeimosOfKosmos
extends CardImpl {
    public AlexiosDeimosOfKosmos(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.BERSERKER);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)TrampleAbility.getInstance());
        AttacksEachCombatStaticAbility ability = new AttacksEachCombatStaticAbility();
        ability.addEffect((Effect)new CantBeSacrificedSourceEffect().setText(", can't be sacrificed"));
        ability.addEffect((Effect)new AlexiosDeimosOfKosmosRestrictionEffect());
        this.addAbility((Ability)ability);
        BeginningOfUpkeepTriggeredAbility upkeepAbility = new BeginningOfUpkeepTriggeredAbility(TargetController.EACH_PLAYER, null, false);
        upkeepAbility.addEffect((Effect)new TargetPlayerGainControlSourceEffect().setText("that player gains control of Alexios"));
        upkeepAbility.addEffect((Effect)new UntapSourceEffect().setText(", untaps it"));
        upkeepAbility.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(1)).setText(", and puts a +1/+1 counter on it"));
        upkeepAbility.addEffect((Effect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("it gains haste until end of turn"));
        this.addAbility((Ability)upkeepAbility);
    }

    public AlexiosDeimosOfKosmos(CardImpl card) {
        super(card);
    }

    public AlexiosDeimosOfKosmos copy() {
        return new AlexiosDeimosOfKosmos(this);
    }

    class AlexiosDeimosOfKosmosRestrictionEffect
    extends RestrictionEffect {
        public AlexiosDeimosOfKosmosRestrictionEffect() {
            super(Duration.WhileOnBattlefield);
            this.staticText = ", and can't attack it's owner";
        }

        public AlexiosDeimosOfKosmosRestrictionEffect(RestrictionEffect effect) {
            super(effect);
        }

        public boolean applies(Permanent permanent, Ability source, Game game) {
            return Objects.equals(permanent.getId(), source.getSourceId());
        }

        public AlexiosDeimosOfKosmosRestrictionEffect copy() {
            return new AlexiosDeimosOfKosmosRestrictionEffect(this);
        }

        public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
            if (defenderId == null) {
                return true;
            }
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            if (permanent == null) {
                return true;
            }
            UUID ownerId = permanent.getOwnerId();
            return !defenderId.equals(ownerId);
        }
    }
}

