/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class AlhammarretHighArbiterCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    String cardName;
    int zoneChangeCounter;

    public AlhammarretHighArbiterCantCastEffect(String cardName) {
        super(Duration.Custom, Outcome.Benefit);
        this.cardName = cardName;
        this.staticText = "Your opponents can't cast spells with the chosen name";
    }

    private AlhammarretHighArbiterCantCastEffect(AlhammarretHighArbiterCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.cardName = effect.cardName;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.zoneChangeCounter = game.getState().getZoneChangeCounter(source.getId());
    }

    public AlhammarretHighArbiterCantCastEffect copy() {
        return new AlhammarretHighArbiterCantCastEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getState().getZoneChangeCounter(source.getId()) != this.zoneChangeCounter;
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You may not cast a card named " + this.cardName + " (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
            if (spellAbility == null) {
                return false;
            }
            Card card = spellAbility.getCharacteristics(game);
            if (card == null) {
                return false;
            }
            return CardUtil.haveSameNames((MageObject)card, (String)this.cardName, (Game)game);
        }
        return false;
    }
}

