/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.a.AlhammarretHighArbiterCantCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;
import mage.util.GameLog;

class AlhammarretHighArbiterEffect
extends OneShotEffect {
    AlhammarretHighArbiterEffect() {
        super(Outcome.Benefit);
        this.staticText = "As {this} enters, each opponent reveals their hand. You choose the name of a nonland card revealed this way.<br>Your opponents can't cast spells with the chosen name";
    }

    private AlhammarretHighArbiterEffect(AlhammarretHighArbiterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AlhammarretHighArbiterEffect copy() {
        return new AlhammarretHighArbiterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl revealedCards = new CardsImpl();
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null) continue;
                CardsImpl cards = new CardsImpl((Collection)opponent.getHand());
                opponent.revealCards(opponent.getName() + "'s hand", (Cards)cards, game);
                revealedCards.addAll((Collection)cards);
            }
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)new FilterNonlandCard("nonland card from an opponents hand"));
            controller.chooseTarget(Outcome.Benefit, (Cards)revealedCards, target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                game.informPlayers("The chosen card name is [" + GameLog.getColoredObjectName((MageObject)card) + ']');
                Permanent sourcePermanent = game.getPermanentEntering(source.getSourceId());
                if (sourcePermanent == null) {
                    sourcePermanent = game.getPermanentEntering(source.getSourceId());
                }
                if (sourcePermanent != null) {
                    sourcePermanent.addInfo("chosen card name", CardUtil.addToolTipMarkTags((String)("Chosen card name: " + card.getName())), game);
                }
                game.addEffect((ContinuousEffect)new AlhammarretHighArbiterCantCastEffect(card.getName()), source);
            }
            return true;
        }
        return false;
    }
}

