/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AlignedHedronNetworkExileEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures with power 5 or greater");

    public AlignedHedronNetworkExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creatures with power 5 or greater until {this} leaves the battlefield";
    }

    private AlignedHedronNetworkExileEffect(AlignedHedronNetworkExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public AlignedHedronNetworkExileEffect copy() {
        return new AlignedHedronNetworkExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        LinkedHashSet toExile = new LinkedHashSet(game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), source, game));
        if (toExile.isEmpty()) {
            return false;
        }
        controller.moveCardsToExile(toExile, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getIdName());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 4));
    }
}

