/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.game.Game;
import mage.players.Player;

enum AllSeeingArbiterValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller == null) {
            return 0;
        }
        HashSet<Integer> manaValues = new HashSet<Integer>();
        for (UUID cardId : controller.getGraveyard()) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            manaValues.add(card.getManaValue());
        }
        return -manaValues.size();
    }

    public AllSeeingArbiterValue copy() {
        return this;
    }

    public String toString() {
        return "-X";
    }

    public String getMessage() {
        return "the number of different mana values among cards in your graveyard";
    }

    public int getSign() {
        return -1;
    }
}

