/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class AllSunsDawnEffect
extends OneShotEffect {
    AllSunsDawnEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "For each color, return up to one target card of that color from your graveyard to your hand";
    }

    private AllSunsDawnEffect(AllSunsDawnEffect effect) {
        super((OneShotEffect)effect);
    }

    public AllSunsDawnEffect copy() {
        return new AllSunsDawnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToHand = new CardsImpl();
            for (Target target : source.getTargets()) {
                UUID targetId = target.getFirstTarget();
                Card card = game.getCard(targetId);
                if (card == null) continue;
                cardsToHand.add(card);
            }
            return controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        }
        return false;
    }
}

