/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.common.FilterCreaturePlayerOrPlaneswalker;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetPermanentOrPlayer;

class AllWillBeOneTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanentOrPlayer filter = new FilterCreaturePlayerOrPlaneswalker("opponent, creature an opponent controls, or planeswalker an opponent controls.");

    AllWillBeOneTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)SavedDamageValue.MUCH));
        this.addTarget((Target)new TargetPermanentOrPlayer(filter));
    }

    private AllWillBeOneTriggeredAbility(AllWillBeOneTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Player player = game.getPlayer(event.getTargetId());
        if (player == null && (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) == null && (permanent = game.getPermanentEntering(event.getTargetId())) == null) {
            return false;
        }
        this.getEffects().setValue("damage", (Object)event.getAmount());
        return true;
    }

    public AllWillBeOneTriggeredAbility copy() {
        return new AllWillBeOneTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you put one or more counters on a permanent or player, {this} deals that much damage to target opponent, creature an opponent controls, or planeswalker an opponent controls.";
    }

    static {
        filter.getPermanentFilter().add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
        filter.getPlayerFilter().add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getPlayerPredicate());
    }
}

