/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AlmsCollectorReplacementEffect
extends ReplacementEffectImpl {
    AlmsCollectorReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.DrawCard);
        this.staticText = "If an opponent would draw two or more cards, instead you and that player each draw a card";
    }

    private AlmsCollectorReplacementEffect(AlmsCollectorReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AlmsCollectorReplacementEffect copy() {
        return new AlmsCollectorReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(event.getPlayerId());
        if (controller != null && opponent != null) {
            controller.drawCards(1, source, game, event);
            opponent.drawCards(1, source, game, event);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_TWO_OR_MORE_CARDS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        return event.getAmount() > 1 && (controller = game.getPlayer(source.getControllerId())) != null && controller.hasOpponent(event.getPlayerId(), game);
    }
}

