/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AlphaBrawlEffect
extends OneShotEffect {
    AlphaBrawlEffect() {
        super(Outcome.Damage);
        this.staticText = "Target creature an opponent controls deals damage equal to its power to each other creature that player controls, then each of those creatures deals damage equal to its power to that creature";
    }

    private AlphaBrawlEffect(AlphaBrawlEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        UUID targetId = source.getFirstTarget();
        FilterCreaturePermanent filter = new FilterCreaturePermanent("each other creature that player controls");
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(targetId)));
        Permanent creature = game.getPermanent(targetId);
        if (creature != null && (player = game.getPlayer(creature.getControllerId())) != null) {
            int power = creature.getPower().getValue();
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, player.getId(), game)) {
                perm.damage(power, creature.getId(), source, game, false, true);
            }
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, player.getId(), game)) {
                creature.damage(perm.getPower().getValue(), perm.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    public AlphaBrawlEffect copy() {
        return new AlphaBrawlEffect(this);
    }
}

