/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.ForetellAbility;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

enum AlrundGodOfTheCosmosValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller != null) {
            Collection exileZones = game.getState().getExile().getExileZones();
            CardsImpl cardsForetoldInExileZones = new CardsImpl();
            FilterCard filter = new FilterCard();
            filter.add((Predicate)new OwnerIdPredicate(controller.getId()));
            filter.add((Predicate)new AbilityPredicate(ForetellAbility.class));
            for (ExileZone exile : exileZones) {
                for (Card card : exile.getCards(filter, game)) {
                    UUID exileId = CardUtil.getExileZoneId((String)(card.getId().toString() + "foretellAbility"), (Game)game);
                    if (exileId == null || game.getState().getExile().getExileZone(exileId) == null) continue;
                    cardsForetoldInExileZones.add(card);
                }
            }
            return controller.getHand().size() + cardsForetoldInExileZones.size();
        }
        return 0;
    }

    public DynamicValue copy() {
        return instance;
    }

    public String getMessage() {
        return "";
    }
}

