/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class AlurenRuleEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature cards with mana value 3 or less");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility;

    public AlurenRuleEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "Any player may cast creature cards with mana value 3 or less without paying their mana cost";
        this.alternativeCastingCostAbility = new AlternativeCostSourceAbility(null, (Condition)SourceIsSpellCondition.instance, null, (FilterCard)filter, true);
        this.alternativeCastingCostAbility.setIdentifier(MageIdentifier.AlurenAlternateCast);
    }

    private AlurenRuleEffect(AlurenRuleEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.alternativeCastingCostAbility = effect.alternativeCastingCostAbility.copy();
    }

    public AlurenRuleEffect copy() {
        return new AlurenRuleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        }
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 3));
    }
}

