/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AmarethTheLustrousEffect
extends OneShotEffect {
    AmarethTheLustrousEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it shares a card type with that permanent, you may reveal that card and put it into your hand";
    }

    private AmarethTheLustrousEffect(AmarethTheLustrousEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmarethTheLustrousEffect copy() {
        return new AmarethTheLustrousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player;
        block7: {
            block6: {
                player = game.getPlayer(source.getControllerId());
                if (player == null) {
                    return false;
                }
                card = player.getLibrary().getFromTop(game);
                if (card == null) {
                    return false;
                }
                player.lookAtCards("Top card of library", card, game);
                Object obj = this.getValue("permanentEnteringBattlefield");
                Permanent permanent = null;
                if (obj instanceof Permanent) {
                    permanent = (Permanent)obj;
                }
                if (permanent == null) break block6;
                if (!card.getCardType(game).stream().noneMatch(permanent.getCardType(game)::contains) && player.chooseUse(Outcome.DrawCard, "Reveal " + card.getName() + " and put it into your hand?", source, game)) break block7;
            }
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        player.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

