/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceLeftOrRight;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AminatouUltimateEffect
extends OneShotEffect {
    AminatouUltimateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose left or right. Each player gains control of all nonland permanents other than {this} controlled by the next player in the chosen direction.";
    }

    private AminatouUltimateEffect(AminatouUltimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public AminatouUltimateEffect copy() {
        return new AminatouUltimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceLeftOrRight choice = new ChoiceLeftOrRight();
            if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) {
                return false;
            }
            boolean left = choice.getChoice().equals("Left");
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId())) {
                playerList.getNext();
            }
            UUID currentPlayer = (UUID)playerList.get();
            UUID firstNextPlayer = null;
            while (!this.getNextPlayerInDirection(left, playerList, game).equals(firstNextPlayer)) {
                UUID nextPlayer = (UUID)playerList.get();
                if (nextPlayer == null) {
                    return false;
                }
                if (!game.getState().getPlayersInRange(controller.getId(), game).contains((Object)nextPlayer)) continue;
                if (firstNextPlayer == null) {
                    firstNextPlayer = nextPlayer;
                }
                FilterNonlandPermanent nextPlayerNonlandPermanentsFilter = new FilterNonlandPermanent();
                nextPlayerNonlandPermanentsFilter.add((Predicate)new ControllerIdPredicate(nextPlayer));
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)nextPlayerNonlandPermanentsFilter, source.getControllerId(), source, game)) {
                    if (permanent.getId().equals(source.getSourceId())) continue;
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, currentPlayer);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
                currentPlayer = nextPlayer;
            }
            return true;
        }
        return false;
    }

    private UUID getNextPlayerInDirection(boolean left, PlayerList playerList, Game game) {
        UUID nextPlayerId = left ? (UUID)playerList.getNext() : (UUID)playerList.getPrevious();
        return nextPlayerId;
    }
}

