/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SalamanderWarriorToken;
import mage.players.Player;

class AmphinMutineerEffect
extends OneShotEffect {
    AmphinMutineerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target non-Salamander creature. That creature's controller creates a 4/3 blue Salamander Warrior creature token";
    }

    private AmphinMutineerEffect(AmphinMutineerEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmphinMutineerEffect copy() {
        return new AmphinMutineerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        new SalamanderWarriorToken().putOntoBattlefield(1, game, source, player.getId());
        return true;
    }
}

