/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AmplifireEffect
extends OneShotEffect {
    AmplifireEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal a creature card. Until your next turn, {this}'s base power becomes twice that card's power and its base toughness becomes twice that card's toughness. Put the revealed cards on the bottom of your library in a random order.";
    }

    private AmplifireEffect(AmplifireEffect effect) {
        super((OneShotEffect)effect);
    }

    public AmplifireEffect copy() {
        return new AmplifireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card lastCard = null;
        for (Card card : player.getLibrary().getCards(game)) {
            if (card == null) continue;
            cards.add(card);
            if (!card.isCreature(game)) continue;
            lastCard = card;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        if (lastCard != null) {
            SetBasePowerToughnessSourceEffect setBasePowerToughnessSourceEffect = new SetBasePowerToughnessSourceEffect(2 * lastCard.getPower().getValue(), 2 * lastCard.getToughness().getValue(), Duration.UntilYourNextTurn);
            game.addEffect((ContinuousEffect)setBasePowerToughnessSourceEffect, source);
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

