/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class AmyPondEffect
extends OneShotEffect {
    private final DynamicValue numberCounters;

    AmyPondEffect(DynamicValue numberCounters) {
        super(Outcome.Benefit);
        this.numberCounters = numberCounters;
        this.staticText = "choose a suspended card you own and remove that many time counters from it";
    }

    private AmyPondEffect(AmyPondEffect effect) {
        super((OneShotEffect)effect);
        this.numberCounters = effect.numberCounters;
    }

    public AmyPondEffect copy() {
        return new AmyPondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getExile().getCard(source.getFirstTarget(), game)) != null) {
            card.removeCounters(CounterType.TIME.toString(), ((Integer)this.getValue("damage")).intValue(), source, game);
            return true;
        }
        return false;
    }
}

