/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class AnHavvaConstableEffect
extends ContinuousEffectImpl {
    AnHavvaConstableEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.CharacteristicDefining_7a, Outcome.BoostCreature);
        this.staticText = "{this}'s toughness is equal to 1 plus the number of green creatures on the battlefield";
    }

    private AnHavvaConstableEffect(AnHavvaConstableEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AnHavvaConstableEffect copy() {
        return new AnHavvaConstableEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject mageObject = game.getObject(source.getSourceId());
        if (mageObject == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("green creatures");
        filter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        int numberOfGreenCreatures = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        mageObject.getToughness().setModifiedBaseValue(1 + numberOfGreenCreatures);
        return true;
    }
}

