/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class AnHavvaInnEffect
extends OneShotEffect {
    AnHavvaInnEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain X plus 1 life, where X is the number of green creatures on the battlefield";
    }

    private AnHavvaInnEffect(AnHavvaInnEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnHavvaInnEffect copy() {
        return new AnHavvaInnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("green creatures");
            filter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
            int greenCreatures = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
            player.gainLife(greenCreatures + 1, game, source);
        }
        return true;
    }
}

