/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AncestralKnowledgeEffect
extends OneShotEffect {
    AncestralKnowledgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top ten cards of your library, then exile any number of them and put the rest back on top of your library in any order";
    }

    private AncestralKnowledgeEffect(AncestralKnowledgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AncestralKnowledgeEffect copy() {
        return new AncestralKnowledgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 10));
            if (!cards.isEmpty()) {
                controller.lookAtCards(source, null, (Cards)cards, game);
                TargetCard target = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, new FilterCard("cards to exile"));
                controller.choose(Outcome.Exile, (Cards)cards, target, source, game);
                CardsImpl toExile = new CardsImpl((Collection)target.getTargets());
                controller.moveCards((Cards)toExile, Zone.EXILED, source, game);
                cards.removeAll((Collection)toExile);
                controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

