/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class AnchorToRealityEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an Equipment or Vehicle card");

    public AnchorToRealityEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Search your library for an Equipment or Vehicle card, put that card onto the battlefield, then shuffle. If it has mana value less than the sacrificed permanent's mana value, scry 2";
    }

    private AnchorToRealityEffect(AnchorToRealityEffect effect) {
        super((OneShotEffect)effect);
    }

    public AnchorToRealityEffect copy() {
        return new AnchorToRealityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        controller.searchLibrary(target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            controller.shuffleLibrary(source, game);
            return true;
        }
        int searchedManaValue = card.getManaValue();
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        controller.shuffleLibrary(source, game);
        int sacrificedManaValue = 0;
        for (Cost cost : source.getCosts()) {
            List sacrificedPermanents;
            if (!(cost instanceof SacrificeTargetCost) || (sacrificedPermanents = ((SacrificeTargetCost)cost).getPermanents()).size() <= 0) continue;
            sacrificedManaValue = ((Permanent)sacrificedPermanents.get(0)).getManaValue();
            break;
        }
        if (searchedManaValue < sacrificedManaValue) {
            controller.scry(2, source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.EQUIPMENT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

