/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.cards.a.AncientBrassDragonTarget;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class AncientBrassDragonEffect
extends OneShotEffect {
    AncientBrassDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d20. When you do, put any number of target creature cards with total mana value X or less from graveyards onto the battlefield under your control, where X is the result";
    }

    private AncientBrassDragonEffect(AncientBrassDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public AncientBrassDragonEffect copy() {
        return new AncientBrassDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 20);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect(), false);
        ability.addTarget((Target)new AncientBrassDragonTarget(result));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

