/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class AncientCopperDragonEffect
extends OneShotEffect {
    AncientCopperDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d20. You create a number of Treasure tokens equal to the result";
    }

    private AncientCopperDragonEffect(AncientCopperDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public AncientCopperDragonEffect copy() {
        return new AncientCopperDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = player.rollDice(Outcome.Benefit, source, game, 20);
        if (amount > 0) {
            new TreasureToken().putOntoBattlefield(amount, game, source);
        }
        return true;
    }
}

