/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class AndTheyShallKnowNoFearEffect
extends OneShotEffect {
    AndTheyShallKnowNoFearEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature type. Creatures you control of the chosen type get +1/+0 and gain indestructible until end of turn";
    }

    private AndTheyShallKnowNoFearEffect(AndTheyShallKnowNoFearEffect effect) {
        super((OneShotEffect)effect);
    }

    public AndTheyShallKnowNoFearEffect copy() {
        return new AndTheyShallKnowNoFearEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        controller.choose(this.outcome, (Choice)choice, game);
        SubType subType = SubType.byDescription((String)choice.getChoiceKey());
        if (subType == null) {
            return false;
        }
        game.informPlayers(controller.getLogName() + " chooses " + subType);
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(permanent -> permanent.hasSubtype(subType, game)).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        game.addEffect(new BoostTargetEffect(1, 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        return true;
    }
}

